from machine import I2C, Pin
import utime
from pico_i2c_adafruit_lcd import I2cLcd
trigger = Pin(20, Pin.OUT)
echo = Pin(21, Pin.IN)
DEFAULT_I2C_ADDR = 0x20
BUS = 0
LCD_SDA = Pin(8, Pin.PULL_UP)
LCD_SCL = Pin(9, Pin.PULL_UP)
i2c = I2C(BUS, sda=LCD_SDA, scl=LCD_SCL, freq = 100000)
lcd = I2cLcd(i2c, DEFAULT_I2C_ADDR, 2, 16)
lcd.putstr("  Elecrow 2013")
utime.sleep_ms(3000)
lcd.clear()
count = 0
def getDistance(trigger, echo):
    trigger.low()
    utime.sleep_us(2)
    trigger.high()
    utime.sleep_us(10)
    trigger.low()
    while echo.value() == 0:
        start = utime.ticks_us()
    while echo.value() == 1:
        end = utime.ticks_us()
    d = (end - start) * 0.0343 / 2 
    return d

if __name__ == "__main__":
    while True:
        global distance
        distance = getDistance(trigger, echo)
        lcd.move_to(0, 0)
        lcd.putstr("Distance: ")
        lcd.move_to(0, 1)
        lcd.putstr("{:.2f}cm".format(distance))
        utime.sleep_ms(500)
        lcd.clear()
        
